/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;

public class SpliceBrush
extends PApplet {
    PImage img;
    int hintFrames = 240;
    int hintEndFrame = 0;
    boolean hintCleared = false;
    int fileNumber = 0;
    Ball[] balls = new Ball[100];

    public void setup() {
        this.background(0);
        this.img = this.loadImage("engel.jpg");
        if (this.img == null) {
            SpliceBrush.println((String)"Kein Startbild gefunden. Dr\u00fccke N zum Laden.");
        }
        this.hintEndFrame = this.frameCount + this.hintFrames;
    }

    public void draw() {
        int i = 0;
        while (i < this.balls.length) {
            if (this.balls[i] != null) {
                this.balls[i].update();
                this.balls[i].changeColour();
                this.balls[i].draw();
                if (this.balls[i].radius < 0.0f) {
                    this.balls[i] = null;
                }
            }
            ++i;
        }
        if (this.frameCount % 240 == 0) {
            this.randomSplice();
        }
        this.handleHint();
    }

    public void handleHint() {
        if (this.frameCount <= this.hintEndFrame) {
            this.drawHintOverlay();
            return;
        }
        if (!this.hintCleared) {
            this.clearHintArea();
            this.hintCleared = true;
        }
    }

    public void drawHintOverlay() {
        this.pushStyle();
        this.noStroke();
        this.fill(0, 170.0f);
        this.rectMode(0);
        this.rect(30.0f, 30.0f, 560.0f, 70.0f, 12.0f);
        this.fill(200);
        this.textAlign(37, 3);
        this.textSize(22.0f);
        this.text("Eigenes Bild mit \"N\" ausw\u00e4hlen.", 50.0f, 65.0f);
        this.popStyle();
    }

    public void clearHintArea() {
        this.pushStyle();
        this.noStroke();
        this.fill(0);
        this.rectMode(0);
        this.rect(30.0f, 30.0f, 560.0f, 70.0f);
        this.popStyle();
    }

    public void mousePressed() {
        if (this.img == null) {
            return;
        }
        int sx = SpliceBrush.constrain((int)((int)((float)this.mouseX + this.random(100.0f))), (int)0, (int)(this.img.width - 1));
        int sy = SpliceBrush.constrain((int)((int)((float)this.mouseY + this.random(100.0f))), (int)0, (int)(this.img.height - 1));
        int c = this.img.get(sx, sy);
        int i = 0;
        while (i < this.balls.length) {
            this.balls[i] = new Ball(this.mouseX, this.mouseY, c, this.img);
            ++i;
        }
    }

    public void keyPressed() {
        if (this.key == 's' || this.key == 'S') {
            this.saveFrameToOutput();
        }
        if (this.key == 'n' || this.key == 'N') {
            this.selectInput("W\u00e4hle ein Bild", "imageSelected");
        }
    }

    public void imageSelected(File selection) {
        if (selection == null) {
            return;
        }
        PImage loaded = this.loadImage(selection.getAbsolutePath());
        if (loaded != null) {
            this.img = loaded;
            this.surface.setSize(this.img.width, this.img.height);
            this.background(0);
        }
    }

    public void saveFrameToOutput() {
        File outDir = new File(this.sketchPath("output"));
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        String filename = this.sketchPath("output/frame-" + SpliceBrush.nf((int)this.fileNumber, (int)4) + ".png");
        this.save(filename);
        SpliceBrush.println((String)("Saved: " + filename));
        ++this.fileNumber;
    }

    public void randomSplice() {
        if (this.img == null) {
            return;
        }
        float rx = this.random(400.0f, this.width - 400);
        float ry = this.random(200.0f, this.height - 200);
        int sx = SpliceBrush.constrain((int)((int)(rx + this.random(100.0f))), (int)0, (int)(this.img.width - 1));
        int sy = SpliceBrush.constrain((int)((int)(ry + this.random(100.0f))), (int)0, (int)(this.img.height - 1));
        int c = this.img.get(sx, sy);
        int i = 0;
        while (i < this.balls.length) {
            this.balls[i] = new Ball(rx, ry, c, this.img);
            ++i;
        }
    }

    public void settings() {
        this.size(1920, 1080);
        this.smooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--full-screen", "--bgcolor=#050505", "--hide-stop", "SpliceBrush"};
        if (passedArgs != null) {
            PApplet.main((String[])SpliceBrush.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Ball {
        PVector pos;
        float radius;
        float r;
        float g;
        float b;
        float xOff = 0.0f;
        float yOff = 0.0f;
        PImage source;

        Ball(float x, float y, int c, PImage source) {
            this.pos = new PVector(x, y);
            this.radius = SpliceBrush.this.random(0.05f);
            this.source = source;
            this.r = SpliceBrush.this.red(c);
            this.g = SpliceBrush.this.green(c);
            this.b = SpliceBrush.this.blue(c);
        }

        public void update() {
            this.radius -= SpliceBrush.this.random(1.0E-4f);
            this.xOff += SpliceBrush.this.random(-0.5f, 0.5f);
            this.yOff += SpliceBrush.this.random(-0.5f, 0.5f);
            this.pos.x += SpliceBrush.this.noise(this.pos.x) * this.xOff;
            this.pos.y += SpliceBrush.this.noise(this.pos.y) * this.yOff;
        }

        public void changeColour() {
            int sy;
            int sx = SpliceBrush.constrain((int)((int)this.pos.x), (int)0, (int)(this.source.width - 1));
            int c = this.source.get(sx, sy = SpliceBrush.constrain((int)((int)this.pos.y), (int)0, (int)(this.source.height - 1)));
            if (SpliceBrush.this.brightness(c) > 1.0f) {
                this.r = SpliceBrush.this.red(c);
                this.g = SpliceBrush.this.green(c);
                this.b = SpliceBrush.this.blue(c);
            }
        }

        public void draw() {
            SpliceBrush.this.noStroke();
            SpliceBrush.this.fill(this.r, this.g, this.b);
            SpliceBrush.this.ellipse(this.pos.x, this.pos.y, this.radius * 40.0f, this.radius * 40.0f);
        }
    }
}

